/*
 * Decompiled with CFR 0.152.
 */
package com.android.gps.domain.use_case;

import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class GetCustomerHasOrderAndInvoice {
    private final DbConnection dbConnection;

    public GenericResponse invoke(RequestData request) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        String customerIds = request.getParamValue("customer-ids");
        if (customerIds == null || customerIds.isEmpty()) {
            throw new TncException(TncExceptionMessages.CUSTOMER_CODE_IS_NEEDED);
        }
        String[] splitd = customerIds.split(",");
        String qouted = ConvertStr.commaBindStringsWithQuotes(Arrays.asList(splitd));
        String fromDate = request.getParamValue("date-from");
        String toDate = request.getParamValue("date-until");
        String sql = "; with t1 as ( \nSelect distinct C_Code From (\nselect c_code as C_Code from Facture F where c_code in (" + qouted + ") " + this.makeWhere(fromDate, toDate, "F.Fac_Date") + " \n Union All \n select R_CusCode as C_Code from RQTITLE R where R_CusCode in (" + qouted + ") " + this.makeWhere(fromDate, toDate, "R.R_Date") + " \n Union All\n select c_code as C_Code from TmpFacture T where c_code in (" + qouted + ") " + this.makeWhere(fromDate, toDate, "T.FDateTime") + " \n) as c), t2 as (\nSelect distinct customerCode as C_Code From RMVisitorGPS where customerCode in (" + qouted + ") " + this.makeWhere(fromDate, toDate, "inDateTime") + " \n)\nSelect \nCOALESCE(t1.c_code, t2.c_code) as c_code,\ncase \nwhen t1.c_code is not null and t2.c_code is not null then 2\nwhen t1.c_code is null and t2.c_code is not null then 1\nelse 0\nend as result\nfrom t1\nFull outer join t2 on t1.c_code = t2.c_code";
        HashMap<String, Integer> result = (HashMap<String, Integer>)jdbc.query(sql, rs -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (rs.next()) {
                map.put(rs.getString("c_code"), rs.getInt("result"));
            }
            return map;
        });
        if (result == null) {
            result = new HashMap<String, Integer>();
        }
        for (String item : splitd) {
            if (result.containsKey(item)) continue;
            result.put(item, 0);
        }
        return GenericResponse.builder().moreInfo(result).build();
    }

    private String makeWhere(String fromDate, String toDate, String date) {
        String where = "";
        if (fromDate != null) {
            where = where + " AND CAST(" + date + " as DATE) >= " + ConvertStr.toQuotedSqlStr((String)fromDate);
        }
        if (toDate != null) {
            where = where + " AND CAST(" + date + " as DATE) <= " + ConvertStr.toQuotedSqlStr((String)toDate);
        }
        return where;
    }

    public GetCustomerHasOrderAndInvoice(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

